cat('\f')

DATA_DIR <- 'E:/Sleep-Raw-202011/period_calc_30min'
setwd(DATA_DIR)

# see metadata in R0 #
library(scopr)
library(ggetho)
library(behavr)
library(damr)
library(zeitgebr)
## time must be set as 't' #
met <- read.csv('metadata.csv')
metatable <- data.table(met, key = 'id')
d <- fread('combined_data.csv')
data <- data.table(d, key = 'id')
dt <- behavr(data, metatable)
dt[, t := t * 1800] # every point is a 5min interval and time window = 30min #
## plot here is same as that in imageJ ##
## p = ggetho(dt, aes(z = activity), multiplot = 2) + stat_bar_tile_etho() + facet_wrap( ~ id, ncol = 8)

## remove the LD part ##
print('please enter the time point (mins) when entering DD and when DD ended')
time_start <- as.numeric(readline())
time_off <- as.numeric(readline())
dt_s <- dt[t > time_start*1800 ]
dt_DD <- dt_s[t < time_off * 1800]
per <- periodogram(activity, dt_DD, FUN = chi_sq_periodogram, resample_rate = 1/mins(30))

# get the raw power data ##
## non-rythmic fly only has peak == 0, find the minimum p-value ##
## for a single fly, each time point can be given a period and a p-value ##
#circa <- per[, .(p_value = min(p_value)), by = id]
#circadian <- per[circa, on = 'p_value']
#write.csv(circadian, 'E:/Sleep-Raw-202011/period_calc/raw_circa_power.csv')

# calculate period length from rhythmic flies ##
## entering threshold for keeping data ##
#print('pleas enter the power threshold')
#power_threshold <- as.numeric(readline())
per_peaks <- find_peaks(per)
period_sum <- rejoin(behavr(per_peaks[peak == 1], metatable))
#period_output <- period_sum[power>=power_threshold]
write.csv(period_sum, 'E:/Sleep-Raw-202011/period_calc_30min/period.csv')


